<?php

namespace App\Http\Controllers;

use App\Models\WarehouseTransfer;
use App\Response;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class WarehouseTransferNoteController extends Controller
{
    public function addNote(Request $request, WarehouseTransfer $transfer): Response
    {
        $request->validate(['note' => 'required']);

        $note = $transfer->notes()->create($request->only('note'));
        $note->load('user');

        return $this->response->addData($note)
            ->setMessage(__('messages.success.create', ['resource' => 'note']));
    }

    /**
     * View sales order notes.
     */
    public function notes(WarehouseTransfer $transfer): JsonResponse
    {
        return $this->response->setData($transfer->notes()->with('user')->orderByDesc('created_at')->paginate()->toArray());
    }

    public function deleteNote(WarehouseTransfer $transfer, $noteId): Response
    {
        $note = $transfer->notes()->find(e($noteId));
        if ($note) {
            $note->delete();
        }

        return $this->response->setMessage(__('messages.success.delete', ['resource' => 'note', 'id' => $noteId]));
    }
}
