<?php

namespace App\Http\Controllers;

use App\Http\Resources\UserApiResource;
use App\Models\UserApi;
use App\Response;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class UserApiController extends Controller
{
    /**
     * Retrieve User Api that auth user has.
     */
    public function index(): AnonymousResourceCollection
    {
        return UserApiResource::collection(UserApi::with('user')->where('user_id', auth()->id())->get());
    }

    /**
     * Create new User Api.
     */
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'name' => 'required|max:255',
        ]);

        $inputs = $request->all();

        $userApi = new UserApi();
        $userApi->name = $inputs['name'];
        $userApi->user_id = auth()->id();
        $userApi->key = md5(uniqid('key_'));
        $userApi->password = md5(uniqid('secret_'));
        $userApi->save();

        return $this->response->success(Response::HTTP_CREATED)
            ->setMessage(__('messages.success.create', ['resource' => 'user api']))
            ->addData(UserApiResource::make($userApi));
    }

    /**
     * Soft Delete User Api.
     *
     *
     * @throws Exception
     */
    public function destroy($user_api_id): Response
    {
        $userApi = UserApi::with([])->findOrFail($user_api_id);

        // Check if authed user has this api.
        if ($userApi->user_id != auth()->id()) {
            abort(401);
        }
        $userApi->delete();

        return $this->response->setMessage(__('messages.success.delete', [
            'resource' => 'user api',
            'id' => $userApi->name ?: $userApi->id,
        ]));
    }
}
