<?php

namespace App\Http\Controllers\Traits;

use App\Models\PurchaseOrder;
use App\Models\SalesCredit;
use App\Models\SalesOrder;
use Illuminate\Support\Facades\Storage;
use PHPJasper\PHPJasper;

trait OrdersExports
{
    public function generateJasperReport(SalesOrder|PurchaseOrder|SalesCredit $order, string $templateName, string $outputFileName, ?string $reportType = null): string
    {
        $input = resource_path("views/jasper_files/{$templateName}");

        $data = $order->extractToPdf($reportType);

        $jsonFile = time().rand(1000, 9999).'.json';
        Storage::disk('jasper_reports')->put($jsonFile, json_encode($data));

        $query = 'items';

        $options = [
            'format' => ['pdf'],
            'params' => collect($data)->except($query)->toArray(),
            'locale' => 'en',
            'db_connection' => [
                'driver' => 'json',
                'data_file' => Storage::disk('jasper_reports')->path($jsonFile),
                'json_query' => $query,
            ],
        ];

        try {
            $outputFile = Storage::disk('reports')->path($outputFileName);
            (new PHPJasper)->process($input, $outputFile, $options)->execute();
            @chmod("{$outputFile}.pdf", 0666);
        } finally {
            Storage::disk('jasper_reports')->delete($jsonFile);
        }

        return "$outputFileName.pdf";
    }
}
