<?php

namespace App\Http\Controllers\Traits;

use App\Jobs\BulkDeleteRecords;
use Carbon\Carbon;
use Illuminate\Http\Request;

/**
 * Trait BulkDeleteProcessor.
 */
trait BulkDeleteProcessor
{
    public function isLargeDelete(string $model, Request $request): bool
    {
        if ($request->has('ids')) {
            $count = count(array_unique($request->input('ids', [])));
        } else {
            $count = $model::with([])
                ->filter($request)
                ->when($request->has('archived'), function ($query) use ($request) {
                    $query->archived($request->get('archived', 0));
                })
                ->limit(31)
                ->count();
        }

        return $count > 30;
    }

    public function processLargeBulkDelete(string $model, Request $request)
    {
        $model::with([])
            ->when($request->has('ids'), function ($query) use ($request) {
                $query->whereIn('id', array_unique($request->input('ids', [])));
            })
            ->when(! $request->has('ids'), function ($query) use ($request) {
                $query->filter($request);
            })
            ->when($request->has('archived'), function ($query) use ($request) {
                $query->archived($request->get('archived', 0));
            })
            ->update(['archived_at' => Carbon::now()]);

        dispatch(new BulkDeleteRecords($model, $request->all()));
    }
}
