<?php

namespace App\Http\Controllers;

use App\Models\TaskStatus\TaskStatus;

/**
 * Class TaskStatusController.
 */
class TaskStatusController extends Controller
{
    public function status($task_id)
    {
        $task = TaskStatus::where('user_id', \Auth::user()->id)->find($task_id);

        if (empty($task)) {
            return response()
                ->json([
                    'messages' => [],
                    'status' => TaskStatus::STATUS_FAILED,
                ]);
        }

        return response()->json($task->getStatus());
    }
}
