<?php

namespace App\Http\Controllers\Shopify;

use App\Http\Controllers\Controller;
use App\Jobs\Shopify\ShopifyProcessOrdersDb;
use App\Models\ProductListing;
use App\Models\Shopify\ShopifyOrder;
use App\Models\Shopify\ShopifyProduct;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ShopifyWebhookControllerDb extends Controller
{
    public function inventoryItemDelete(Request $request, $integrationInstanceId): JsonResponse
    {
        ShopifyProduct::with([])->where('integration_instance_id', (int) $integrationInstanceId)
            ->where('inventory_item_id', $request->input('id'))
            ->update(['removed_from_shopify' => 1]);

        return response()->json(['status' => 'success']);
    }

    public function productCreate(Request $request, $integrationInstanceId): JsonResponse
    {
        return response()->json(['status' => 'success']);
    }

    public function productUpdate(Request $request, $integrationInstanceId): JsonResponse
    {
        return response()->json(['status' => 'success']);
    }

    public function inventoryLevelUpdate(Request $request, $integrationInstanceId): JsonResponse
    {
        $documentId = ShopifyProduct::with([])->where('integration_instance_id', (int) $integrationInstanceId)
            ->where('inventory_item_id', $request->input('inventory_item_id'))
            ->value('_id');

        ProductListing::with([])->where('document_id', $documentId)
            ->update([
                'sales_channel_qty' => $request->input('available'),
                'sales_channel_qty_last_updated' => Carbon::parse($request->input('updated_at'))->timezone('UTC'),
            ]);

        return response()->json(['status' => 'success']);
    }

    public function orderCreate(Request $request, $integrationInstanceId)
    {
        dispatch_sync((new ShopifyProcessOrdersDb([$request->except('token')], $integrationInstanceId, ['downloaded_by' => ShopifyOrder::DOWNLOADED_BY_WEBHOOK]))->onConnection('sync'));
    }

    public function orderUpdated(Request $request, $integrationInstanceId)
    {
        dispatch_sync((new ShopifyProcessOrdersDb([$request->except('token')], $integrationInstanceId, ['downloaded_by' => ShopifyOrder::DOWNLOADED_BY_WEBHOOK]))->onConnection('sync'));
    }
}
