<?php

namespace App\Http\Controllers;

use App\Models\IntegrationInstance;
use App\Response;
use App\Services\ShippingProvider\ShippingProviderIntegrationManager;
use Throwable;


class ShippingProviderIntegrationInstanceController extends Controller
{
    /**
     * @param  ShippingProviderIntegrationManager  $manager
     */
    public function __construct(
        protected readonly ShippingProviderIntegrationManager $manager
    )
    {
        parent::__construct();
    }

    /**
     * @param  IntegrationInstance  $integrationInstance
     * @return Response
     * @throws Throwable
     */
    public function destroy(IntegrationInstance $integrationInstance): Response
    {
        $this->manager->deleteIntegrationInstance($integrationInstance);

        return $this->response->setMessage('Integration instance deleted successfully');
    }
}
