<?php

namespace App\Http\Controllers\ShipStation;

use App\Http\Controllers\Controller;
use App\Jobs\ShipStation\ShipStationHandleWebhookJob;
use App\Models\IntegrationInstance;
use App\SDKs\ShipStation\Model\ShipStationWebhook;
use Illuminate\Http\Request;

class ShipStationWebhooksController extends Controller
{
    public function __invoke(Request $request)
    {
        $request->validate(
            [
                'resource_url' => 'required',
                'resource_type' => 'required',
            ]
        );
        $webhook = new ShipStationWebhook();
        $webhook->resource_url = $request->resource_url;
        $webhook->resource_type = $request->resource_type;

        if ($integrationInstance = IntegrationInstance::shipstation()->first()) {
            dispatch(new ShipStationHandleWebhookJob($integrationInstance, $webhook));
        }
    }
}
