<?php

namespace App\Http\Controllers;

use App\Repositories\Accounting\AccountingTransactionRepository;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportingAccountingController extends Controller
{
    private AccountingTransactionRepository $accountingTransactionRepository;

    public function __construct()
    {
        parent::__construct();
        $this->accountingTransactionRepository = app(AccountingTransactionRepository::class);
    }

    /**
     * @throws Exception
     */
    public function incomeStatement(Request $request): AnonymousResourceCollection
    {
        $request->validate([
            'period' => 'required|string',
            'trailing_days' => 'nullable|integer',
        ]);

        return JsonResource::collection(
            $this->accountingTransactionRepository->getIncomeStatement($request->input('period'), $request->input('trailing_days'))
        )->additional([
            'status' => __('messages.status_success'),
        ]);
    }
}
