<?php

namespace App\Http\Controllers;

use App\Http\Requests\ReportTemplateRequest;
use App\ReportTemplate;
use App\Response;

/**
 * Class ReportTemplateController.
 */
class ReportTemplateController extends Controller
{
    public function index(): Response
    {
        $templates = ReportTemplate::with([])->get();

        return $this->response->addData($templates);
    }

    public function store(ReportTemplateRequest $request): Response
    {
        $template = ReportTemplate::with([])->create($request->validated());

        return $this->response->addData($template);
    }

    public function update(ReportTemplateRequest $request, $templateId): Response
    {
        $template = ReportTemplate::with([])->findOrFail(e($templateId));
        $template->fill($request->validated());
        $template->save();

        return $this->response->addData($template);
    }

    public function destroy($templateId): Response
    {
        $template = ReportTemplate::with([])->findOrFail(e($templateId));
        $template->delete();

        return $this->response;
    }
}
