<?php

namespace App\Http\Controllers\Magento;

use App\Enums\DownloadedBy;
use App\Http\Controllers\Controller;
use App\Jobs\Magento\GetProducts;
use App\Models\IntegrationInstance;
use App\Response;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    /**
     * Download Magento Products by id or sku
     */
    public function download(Request $request, IntegrationInstance $integrationInstance): Response
    {
        $request->validate(['ids' => 'required_without:skus|array|min:1', 'skus' => 'required_without:ids|array|min:1']);

        $options = ['downloaded_by' => DownloadedBy::Command, 'pageSize' => 300];
        if ($request->has('ids')) {
            $options['filterGroups'][]['filters'][0] = [
                'field' => 'entity_id',
                'conditionType' => 'in',
                'value' => implode(',', $request->input('ids')),
            ];
        }

        if ($request->has('skus')) {
            $options['filterGroups'][]['filters'][0] = [
                'field' => 'sku',
                'conditionType' => 'in',
                'value' => implode(',', $request->input('skus')),
            ];
        }

        dispatch_sync(new GetProducts($integrationInstance, $options));

        return $this->response->setMessage(__('messages.success.download', ['resource' => 'magento products']));
    }
}
