<?php

namespace App\Http\Controllers\Magento;

use App\Http\Controllers\Controller;
use App\Jobs\Magento\GetInventorySourcesJob;
use App\Models\IntegrationInstance;
use App\Models\Magento\InventorySource;

class InventorySourceController extends Controller
{
    public function index(IntegrationInstance $integrationInstance)
    {
        return $this->response->addData([
            'magentoSources' => InventorySource::query()->where('integration_instance_id', $integrationInstance->id)->get()->toArray(),
            'inventorySources' => $integrationInstance->integration_settings['inventorySources'] ?? [],
        ]);
    }

    public function download(IntegrationInstance $integrationInstance)
    {
        GetInventorySourcesJob::dispatchSync($integrationInstance);
        // refresh to update integration_settings
        $integrationInstance->refresh();

        return $this->index($integrationInstance);
    }
}
