<?php

namespace App\Http\Controllers;

use App\Models\DataImportMapping;
use App\Models\IntegrationInstance;
use App\Response;
use Illuminate\Http\Request;

class ImportMappingController extends Controller
{
    public function forModel(Request $request, string $model): Response
    {
        return $this->response->addData(
            DataImportMapping::with([])->where('model', e($model))
                ->filter($request)->first() ?? []
        );
    }

    public function updateMapping(Request $request, ?IntegrationInstance $integrationInstance = null, $model = null)
    {
        $payload = $request->all();
        $mappings = $payload['mapping'];
        if (! empty($mappings) && $integrationInstance) {
            DataImportMapping::setForModel($model, $mappings, [
                'integration_instance_id' => $integrationInstance->id,
            ]);
        }

        return $this->response->setMessage('Field mappings saved .');
    }
}
