<?php

namespace App\Http\Controllers;

use App\DTO\FinancialLineTypeDto;
use App\Models\FinancialLineType;
use App\Repositories\FinancialLineTypeRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class FinancialLineTypeController extends Controller
{
    private FinancialLineTypeRepository $financialLineTypeRepository;

    public function __construct()
    {
        parent::__construct();
        $this->financialLineTypeRepository = app(FinancialLineTypeRepository::class);
    }

    public function store(Request $request)
    {
        // Validate
        $inputs = $request->validate(FinancialLineTypeDto::rules());

        return $this->financialLineTypeRepository->save(FinancialLineTypeDto::from($inputs));
    }

    public function update(Request $request, FinancialLineType $financialLineType)
    {
        // Validate
        $inputs = $request->validate(FinancialLineTypeDto::rules());
        $inputs['id'] = $financialLineType->id;

        return $this->financialLineTypeRepository->save(FinancialLineTypeDto::from($inputs));
    }

    public function index()
    {
        return $this->financialLineTypeRepository->query();
    }

    public function destroy(FinancialLineType $financialLineType): Response
    {
        $financialLineType->delete();

        return response()->noContent();
    }
}
