<?php

namespace App\Http\Controllers;

use App\DataTable\DataTable;
use App\Http\Resources\FinancialAlertResource;
use App\Managers\FinancialAlertManager;
use App\Models\FinancialAlert;
use App\Repositories\FinancialAlertRepository;
use App\Response;
use Illuminate\Http\Request;

class FinancialAlertController extends Controller
{
    use DataTable;

    public function __construct(private readonly FinancialAlertRepository $financialAlerts)
    {
        parent::__construct();
    }

    protected function getModel()
    {
        return FinancialAlert::class;
    }

    protected function getResource()
    {
        return FinancialAlertResource::class;
    }

    public function update(Request $request, FinancialAlert $financialAlert): Response
    {
        $financialAlert->update($request->all());

        return $this->response->addData(FinancialAlertResource::make($financialAlert->refresh()))
            ->setMessage('Financial alert updated successfully');
    }

    public function process(): Response
    {
        app(FinancialAlertManager::class)->createFinancialAlerts();

        return $this->response->setMessage('Financial alerts processed successfully');
    }

    public function archive(FinancialAlert $financialAlert): Response
    {
        $financialAlert->archived_at = now();
        $financialAlert->archived_by_user_id = auth()->id();
        $financialAlert->save();

        return $this->response->addData(FinancialAlertResource::make($financialAlert))
            ->setMessage('Financial alert archived successfully');
    }

    public function unarchive(FinancialAlert $financialAlert): Response
    {
        $financialAlert->archived_at = null;
        $financialAlert->archived_by_user_id = null;
        $financialAlert->save();

        return $this->response->addData(FinancialAlertResource::make($financialAlert))
            ->setMessage('Financial alert unarchived successfully');
    }

    public function getDashboardData(): Response
    {
        return $this->response->addData($this->financialAlerts->getDashboardData());
    }
}
