<?php

namespace App\Http\Controllers;

use App\Http\Resources\FinancialAlertClassificationResource;
use App\Models\FinancialAlertClassification;
use App\Response;
use Illuminate\Http\Request;

class FinancialAlertClassificationController extends Controller
{
    public function index(): Response
    {
        $financialAlertClassifications = FinancialAlertClassification::all();

        return $this->response->addData(FinancialAlertClassificationResource::collection($financialAlertClassifications));
    }

    public function store(Request $request): Response
    {
        $request->validate([
            'name' => 'required|string',
        ]);

        $financialAlertClassification = new FinancialAlertClassification();
        $financialAlertClassification->name = $request->name;
        $financialAlertClassification->save();

        return $this->response->success(Response::HTTP_CREATED)
            ->setMessage(__('messages.success.create', ['resource' => 'financial alert classification']))
            ->addData(FinancialAlertClassificationResource::make($financialAlertClassification));
    }
}
