<?php

namespace App\Http\Controllers;

use App\Data\CreateDropshipData;
use App\Data\CreateDropshipShipmentData;
use App\Exceptions\SalesOrder\SalesOrderFulfillmentDispatchException;
use App\Http\Resources\PurchaseOrderResource;
use App\Http\Resources\SalesOrderFulfillmentResource;
use App\Managers\DropshipManager;
use App\Models\PurchaseOrder;
use App\Models\SalesOrder;
use App\Response;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Http\Request;
use Throwable;

class DropshipController extends Controller
{
    private DropshipManager $dropshipManager;

    public function __construct()
    {
        parent::__construct();
        $this->dropshipManager = app(DropshipManager::class);
    }

    public function store(Request $request, SalesOrder $salesOrder): Response
    {
        $data = CreateDropshipData::from([
            'sales_order_id' => $salesOrder->id,
            ...$request->toArray()
        ]);
        return $this->response->addData(PurchaseOrderResource::make($this->dropshipManager->create($data)));
    }

    /**
     * @throws SalesOrderFulfillmentDispatchException
     * @throws BindingResolutionException
     * @throws Throwable
     */
    public function ship(CreateDropshipShipmentData $data, PurchaseOrder $purchaseOrder): Response
    {
        return $this->response->addData(SalesOrderFulfillmentResource::make($this->dropshipManager->ship($data, $purchaseOrder)));
    }
}
