<?php

namespace App\Http\Controllers;

use App\Http\Requests\Connection\CheckFtpConnectionRequest;
use Illuminate\Support\Facades\Storage;

class ConnectionController extends Controller
{
    public function checkFtp(CheckFtpConnectionRequest $request)
    {
        try {
            $ftpType = $request->ftp_is_sftp ? 'createSftpDriver' : 'createFtpDriver';

            $adapter = Storage::$ftpType([
                'host' => $request->ftp_host,
                'username' => $request->ftp_username,
                'password' => $request->ftp_password,
                'port' => $request->ftp_port,
                'timeout' => (isset($request->ftp_timeout) ? $request->ftp_timeout : 10),
            ]);

            //Check connection
            $adapter->getDriver()->getAdapter()->connect();

            return $this->response->success()->addData([
                'connection' => true,
            ]);
        } catch (\Exception $e) {
            return $this->response->error()->addData([
                'connection' => false,
            ]);
        }
    }
}
