<?php

namespace App\Http\Controllers;

use App\CompanyProfile;
use App\Http\Requests\CompanyProfile\UpdateCompanyProfileRequest;
use App\Http\Resources\CompanyProfileResource;

class CompanyProfileController extends Controller
{
    public function index()
    {
        return $this->response->addData(CompanyProfileResource::make(CompanyProfile::query()->firstOrNew()));
    }

    public function update(UpdateCompanyProfileRequest $request)
    {
        $companyProfile = CompanyProfile::query()->firstOrNew();
        $companyProfile->fill($request->validated());
        $companyProfile->save();

        return $this->response->setMessage(__('messages.success.update', ['resource' => 'company profile', 'id' => $companyProfile->id]))
            ->addData(CompanyProfileResource::make($companyProfile));
    }
}
