<?php

namespace App\Http\Controllers;

use App\Http\Resources\PurchaseOrderResource;
use App\Models\PurchaseOrder;
use App\Models\SupplierPricingTier;
use App\Services\PurchaseOrder\PurchaseOrderManager;
use Illuminate\Http\Request;

class ApplyPurchaseOrderPricingTierController extends PurchaseOrderController
{
    public function __invoke(Request $request, PurchaseOrder $purchaseOrder, SupplierPricingTier $supplierPricingTier)
    {
        app(PurchaseOrderManager::class)->applyPricingTier($purchaseOrder, $supplierPricingTier);

        return $this->response
            ->setMessage('Pricing tier successfully applied.')
            ->addData(PurchaseOrderResource::make($purchaseOrder));
    }
}
