<?php

namespace App\Http\Controllers;

use App\Managers\AdvancedShipmentNoticeManager;
use App\Abstractions\AdvancedShipmentNoticeInterface;
use App\Models\PurchaseOrder;
use App\Models\Warehouse;
use App\Models\WarehouseTransfer;
use App\Response;

class AdvancedShipmentNoticeController extends Controller
{
    public function __construct(private AdvancedShipmentNoticeManager $advancedShipmentNoticeManager)
    {
        parent::__construct();
    }

    public function sendForPurchaseOrder(PurchaseOrder $purchaseOrder): Response
    {
        if ($purchaseOrder->destinationWarehouse->type != Warehouse::TYPE_3PL) {
            return $this->response->error(Response::HTTP_UNPROCESSABLE_ENTITY)
                ->setMessage('Warehouse should be 3PL');
        }
        if (!$purchaseOrder->destinationWarehouse->address->email) {
            return $this->response->error(Response::HTTP_UNPROCESSABLE_ENTITY)
                ->setMessage('Destination address should has an email');
        }
        return $this->send($purchaseOrder);
    }

    public function sendForWarehouseTransfer(WarehouseTransfer $warehouseTransfer): Response
    {
        if ($warehouseTransfer->toWarehouse->type != Warehouse::TYPE_3PL) {
            return $this->response->error(Response::HTTP_UNPROCESSABLE_ENTITY)
                ->setMessage('Warehouse should be 3PL');
        }
        if (!$warehouseTransfer->toWarehouse->address->email) {
            return $this->response->error(Response::HTTP_UNPROCESSABLE_ENTITY)
                ->setMessage('Destination address should has an email');
        }
        return $this->send($warehouseTransfer);
    }

    private function send(AdvancedShipmentNoticeInterface $order): Response
    {
        $this->advancedShipmentNoticeManager->send($order);

        return $this->response->setMessage('ASN email sent successfully.');
    }
}