<?php

namespace App\Http\Controllers;

use App\Managers\UserManager;
use App\Response;
use Illuminate\Http\Request;

class AccountSetupController extends Controller
{
    public function __construct(
        protected UserManager $userManager
    ) {
        parent::__construct();
    }
    public function accountSetup(Request $request): Response
    {
        $request->validate([
            'password' => 'required|string|min:8|confirmed',
            'token' => 'required|string|exists:users,activation_token',
        ]);
        $user = $this->userManager->activateUser($request->token, $request->password);
        return $this->response->setMessage(__('messages.success.update', ['resource' => 'user', 'id' => $user->name]));
    }

    public function verifyActivationToken(Request $request): Response
    {
        $request->validate([
            'token' => 'required|string|exists:users,activation_token',
        ]);
        return $this->response->setMessage('Token is valid');
    }
}
