<?php

namespace App\Helpers;

use Illuminate\Http\Response;

class HttpCspHelper
{
    private static $nonces = [];

    /**
     * Generates a nonce and stores it so it can be added as a
     * response header later.
     */
    public static function nonce(): string
    {
        $nonce = bin2hex(random_bytes(16));
        self::$nonces[] = "'nonce-".$nonce."'";

        return $nonce;
    }

    /**
     * Given a response object, sets the HTTP Content Security
     * Policy header, adding the nonces for inline script tags as
     * needed.
     */
    public static function setCspHeader(Response $response): string
    {
        if (! env('SKIP_HTTP_CONTENT_SECURITY_POLICY', false)) {
            $header = config('httpcsp.header', "default-src 'self' {{nonces}}");
            $header = str_replace('{{nonces}}', implode(' ', self::$nonces), $header);
            $response->headers->set('Content-Security-Policy', $header);
        }

        return $response;
    }
}
