<?php

namespace App\Exporters;

use App\Helpers\ExcelHelper;

class ListingExporter
{
    public static function exportRecords(array $data, $format)
    {
        return static::export(
            $format,
            $data
        );
    }

    public static function export($format, array $data)
    {
        $records = collect($data['records'] ?? []);
        $headers = $data['headers'] ?? [];
        $xlsxheaders = $data['xlsxheaders'] ?? [];

        if ($format === 'xlsx') {
            $output = ExcelHelper::array2xlsxfile(
                intval(date('YmdHis').rand(0, 99999)).'_'.\Auth::id().'_listings_export.xlsx',
                $xlsxheaders,
                $records,
                [
                    'widths' => $data['widths'] ?? [],
                ]
            );
        } else {
            $output = ExcelHelper::array2csvfile(intval(date('YmdHis').rand(0, 99999)).'_'.\Auth::id()."_{$data['filename']}.csv", $headers, $records);
        }

        return $output;
    }
}
