<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 12/10/20
 * Time: 10:58 PM.
 */

namespace App\Exporters\Formatters;

/**
 * Class ExportFormatterFactory.
 */
class ExportFormatterFactory
{
    const EXPORT_FORMAT_CSV = 'csv';

    const EXPORT_FORMAT_XLSX = 'xlsx';

    const SUPPORTED_FORMATS = [
        self::EXPORT_FORMAT_CSV,
        self::EXPORT_FORMAT_XLSX,
    ];

    /**
     * @return CsvExportEngine|XlsxExportEngine
     */
    public static function make($format)
    {
        if (! in_array($format, self::SUPPORTED_FORMATS)) {
            throw new \InvalidArgumentException("Format {$format} is not supported.");
        }

        switch ($format) {
            case self::EXPORT_FORMAT_CSV:
                return new CsvExportEngine;
            default:
                return new XlsxExportEngine;
        }
    }
}
