<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 9/25/20
 * Time: 1:47 PM.
 */

namespace App\Exceptions\PurchaseOrder;

use App\Models\PurchaseOrder;
use Throwable;

/**
 * Class NotOpenPurchaseOrderException.
 */
class NotOpenPurchaseOrderException extends \Exception
{
    /**
     * @var PurchaseOrder
     */
    public $purchaseOrder;

    /**
     * NotOpenPurchaseOrderException constructor.
     */
    public function __construct(PurchaseOrder $purchaseOrder, string $message = '', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->purchaseOrder = $purchaseOrder;
    }
}
