<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 7/8/20
 * Time: 7:15 PM.
 */

namespace App\Exceptions;

use App\Response;

/**
 * Class InsufficientFifoLayerException.
 */
class NegativeInventoryFulfilledSalesOrderLinesException extends \Exception
{
    public array $fulfilledSalesOrderLines;

    public function __construct(array $fulfilledSalesOrderLines)
    {
        parent::__construct('Unable to reduce inventory because there are fulfilled sales order lines that have used this inventory');
        $this->fulfilledSalesOrderLines = $fulfilledSalesOrderLines;
    }

    public function getResponseError(): array
    {
        return Response::getError($this->message, 0, 'product', $this->fulfilledSalesOrderLines);
    }
}
