<?php

namespace App\Exceptions\IntegrationInstance\Magento;

use App\Models\Magento\Order;

class UnmappedStoreException extends \Exception
{
    public function __construct(Order $order)
    {
        $message = "No mapping found for magento store: {$order->json_object['store_name']} ({$order->json_object['store_id']})";

        parent::__construct($message);
    }
}
