<?php

namespace App\Exceptions;

use App\Models\Product;
use App\Response;
use Exception;
use Throwable;

class InsufficientStockException extends Exception
{
    public int $productId;

    public string $productSku;

    private int $shortage;

    /**
     * InsufficientStockException constructor.
     */
    public function __construct($productId, string $message = 'Insufficient stock', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->productId = $productId;
        $this->productSku = Product::with([])->findOrFail($productId)->sku;
    }

    public function getResponseError(): array
    {
        return Response::getError($this->message, Response::CODE_INSUFFICIENT_STOCK, 'product', ['id' => $this->productId, 'sku' => $this->productSku]);
    }

    public function setShortage(int $shortage): void
    {
        $this->shortage = $shortage;
    }

    public function getShortage(): int
    {
        return $this->shortage;
    }
}
