<?php

namespace App\Exceptions;

use Exception;

class ApiException extends Exception
{
    protected mixed $requestBody;

    protected mixed $responseBody;

    protected mixed $responseObject;

    /**
     * Constructor
     *
     * @param  string  $message Error message
     * @param  int  $code HTTP status code
     * @param  string[]|null  $responseHeaders HTTP response header
     * @param  mixed|null  $responseBody HTTP decoded body of the server response either as \stdClass or string
     */
    public function __construct(string $message = '', int $code = 0, $requestBody = null, protected ?array $responseHeaders = [], mixed $responseBody = null)
    {
        parent::__construct($message, $code);
        $this->requestBody = $requestBody;
        $this->responseBody = $responseBody;
    }

    public function getRequestBody(): mixed
    {
        return $this->requestBody;
    }

    /**
     * Gets the HTTP response header
     *
     * @return string[]|null HTTP response header
     */
    public function getResponseHeaders(): ?array
    {
        return $this->responseHeaders;
    }

    /**
     * Gets the HTTP body of the server response either as Json or string
     *
     * @return mixed HTTP body of the server response either as \stdClass or string
     */
    public function getResponseBody(): mixed
    {
        return $this->responseBody;
    }

    /**
     * Sets the deserialized response object (during deserialization)
     *
     * @param  mixed  $obj Deserialized response object
     */
    public function setResponseObject(mixed $obj): void
    {
        $this->responseObject = $obj;
    }

    /**
     * Gets the deserialized response object (during deserialization)
     *
     * @return mixed the deserialized response object
     */
    public function getResponseObject(): mixed
    {
        return $this->responseObject;
    }
}
