<?php

namespace App\Exceptions;

use App\Response;

class ActionUnavailableTemporaryException extends \Exception
{
    public function __construct(string $message = '', int $code = 0, ?\Throwable $previous = null)
    {
        $message = empty($message) ? 'This action is not currently available because there is another user who is performing it now.' : $message;
        $code = $code ?: Response::HTTP_BAD_REQUEST;

        parent::__construct($message, $code, $previous);
    }

    public function getResponseError(string $key, array $data = []): array
    {
        return Response::getError($this->getMessage(), Response::CODE_ACTION_UNAVAILABLE_TEMPORARY, $key, $data);
    }
}
