<?php

namespace App\Events;

use App\Models\SalesOrderLine;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SalesOrderLineDeleted implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public SalesOrderLine $salesOrderLine;

    /**
     * Create a new event instance.
     */
    public function __construct(SalesOrderLine $salesOrderLine)
    {
        $this->salesOrderLine = $salesOrderLine;
    }
}
