<?php

namespace App\Events;

use App\Models\SalesOrder;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SalesOrderCreated implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public SalesOrder $salesOrder;

    public bool $isFBA;

    /**
     * Create a new event instance.
     */
    public function __construct(SalesOrder $salesOrder, bool $isFBA = false)
    {
        $this->salesOrder = $salesOrder;
        $this->isFBA = $isFBA;
    }
}
