<?php

namespace App\Events;

use App\Models\PurchaseOrder;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PurchaseOrderModified implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public PurchaseOrder $purchaseOrder;

    public array $originalData;

    /**
     * Create a new event instance.
     */
    public function __construct(PurchaseOrder $purchaseOrder, array $originalDate)
    {
        $this->purchaseOrder = $purchaseOrder;
        $this->originalData = $originalDate;
    }
}
