<?php

namespace App\Events;

use App\Models\PurchaseOrderLine;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PurchaseOrderLineDeleted implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public PurchaseOrderLine $purchaseOrderLine;

    /**
     * Create a new event instance.
     */
    public function __construct(PurchaseOrderLine $purchaseOrderLine)
    {
        $this->purchaseOrderLine = $purchaseOrderLine;
    }
}
