<?php

namespace App\Events;

use App\Models\PurchaseInvoice;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class PurchaseInvoiceCreated implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public PurchaseInvoice $purchaseInvoice;

    /**
     * Create a new event instance.
     */
    public function __construct(PurchaseInvoice $purchaseInvoice)
    {
        $this->purchaseInvoice = $purchaseInvoice;
    }
}
