<?php

namespace App\Events;

use App\Models\InventoryAdjustment;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class InventoryAdjusted implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public InventoryAdjustment $inventoryAdjustment;

    /**
     * Create a new event instance.
     */
    public function __construct(InventoryAdjustment $inventoryAdjustment)
    {
        $this->inventoryAdjustment = $inventoryAdjustment;
    }
}
