<?php

namespace App\Events;

use App\Models\InventoryMovement;
use App\Models\PurchaseOrder;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class GoodsReceived implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public PurchaseOrder $purchaseOrder;

    /**
     * @var InventoryMovement
     */
    public $inventoryMovement;

    /**
     * Create a new event instance.
     */
    public function __construct(PurchaseOrder $purchaseOrder, InventoryMovement $inventoryMovement)
    {
        $this->purchaseOrder = $purchaseOrder;
        $this->inventoryMovement = $inventoryMovement;
    }
}
