<?php

namespace App\Enums;

use App\Models\InventoryAdjustment;
use App\Models\PurchaseInvoice;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderShipmentReceipt;
use App\Models\SalesCredit;
use App\Models\SalesCreditReturn;
use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Models\StockTake;
use App\Models\WarehouseTransferShipment;
use App\Models\WarehouseTransferShipmentReceipt;
use Exception;

enum AccountingTransactionTypeEnum: string
{
    case SALES_ORDER_INVOICE = 'sales_order_invoice';
    case BATCH_SALES_ORDER_INVOICE = 'batch_sales_order_invoice';
    case SALES_ORDER_FULFILLMENT = 'sales_order_fulfillment';
    case PURCHASE_ORDER = 'purchase_order';
    case PURCHASE_ORDER_INVOICE = 'purchase_order_invoice';
    case PURCHASE_ORDER_RECEIPT = 'purchase_order_receipt';
    case INVENTORY_ADJUSTMENT = 'inventory_adjustment';
    case CUSTOMER_RETURN = 'customer_return';
    case SALES_CREDIT = 'sales_credit';
    case STOCK_TAKE = 'stock_take';
    case WAREHOUSE_TRANSFER_SHIPMENT = 'warehouse_transfer_shipment';
    case WAREHOUSE_TRANSFER_RECEIPT = 'warehouse_transfer_receipt';
    case RECEIVING_DISCREPANCY = 'receiving_discrepancy';

    public static function getCasesWithFinancialDocuments(): array
    {
        return array_filter(self::cases(), fn($case) => $case != self::BATCH_SALES_ORDER_INVOICE);
    }

    /**
     * @throws Exception
     */
    public function getFinancialDocumentClass(): string
    {
        return match ($this) {
            self::SALES_ORDER_INVOICE => SalesOrder::class,
            self::SALES_ORDER_FULFILLMENT => SalesOrderFulfillment::class,
            self::PURCHASE_ORDER, self::RECEIVING_DISCREPANCY => PurchaseOrder::class,
            self::PURCHASE_ORDER_INVOICE => PurchaseInvoice::class,
            self::PURCHASE_ORDER_RECEIPT => PurchaseOrderShipmentReceipt::class,
            self::INVENTORY_ADJUSTMENT => InventoryAdjustment::class,
            self::CUSTOMER_RETURN => SalesCreditReturn::class,
            self::SALES_CREDIT => SalesCredit::class,
            self::STOCK_TAKE => StockTake::class,
            self::WAREHOUSE_TRANSFER_SHIPMENT => WarehouseTransferShipment::class,
            self::WAREHOUSE_TRANSFER_RECEIPT => WarehouseTransferShipmentReceipt::class,
            default => throw new Exception('Unexpected financial document class match value ' . $this->value),
        };
    }
}