<?php

namespace App\DataTable;

class BuildTableSpecifications
{
    public function __construct(protected readonly DataTableModelInterface $model)
    {
    }

    public function build(): array
    {
        $labels = $this->initializeLabels($this->model->availableColumns(), $this->model->specialLabels());

        $columns = [];
        $order = 1;
        foreach ($this->model->availableColumns() as $field => $type) {
            $group = $this->model->columnGroups()->toCollection()->where('column', $field)->first();
            $columns[] = [
                'data_name' => $field,
                'column_label' => $labels[$field],
                'default_order' => $order++,
                'group' => $group->group,
                'group_data' => $group->group_data,
                'default_visible' => in_array($field, $this->model->visibleColumns()),
                'filterable' => in_array($field, $this->model->filterableColumns()),
                'sortable' => in_array($field, $this->model->sortableColumns()),
                'editable' => 0,
                'type' => $this->mapType($type),
            ];
        }
        return [
            'rows_deletable' => $this->model::isDeletable(),
            'frozen_columns' => $this->model::frozenColumns(),
            'default_sort' => $this->model::defaultSort(),
            'default_density' => $this->model::defaultDensity(),
            'columns' => $columns
        ];
    }

    private function initializeLabels(array $fields, array $specialLabels): array
    {
        $labels = [];
        foreach (array_keys($fields) as $field) {
            $labels[$field] = array_key_exists($field, $specialLabels) ? $specialLabels[$field] : ucwords(str_replace('_', ' ', $field));
        }
        return $labels;
    }

    private function mapType(string $type): string
    {
        return match ($type) {
            'float' => 'decimal',
            'datetime' => 'date/time',
            'timestamp' => 'date/time',
            'boolean' => 'checkbox',
            'json', 'longtext', 'mediumtext', 'text' => 'array',
            'varchar' => 'string',
            'bigint', 'mediumint', 'int' => 'integer',
            default => $type,
        };
    }
}