<?php

namespace App\Data;

use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\GreaterThan;
use Spatie\LaravelData\Attributes\Validation\Min;
use Spatie\LaravelData\Attributes\Validation\Unique;
use Spatie\LaravelData\Data;

class WarehouseTransferReceiptBlemishedData extends Data
{
    public function __construct(
        #[Exists('products','id')]
        public int $product_id,
        public string $sku,
        #[Min(0)]
        public int $quantity,
        public ?string $condition,
        public ?string $reference,
    )
    {
    }
}
