<?php

namespace App\Data;

use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Unique;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\References\RouteParameterReference;

class UpdateShippingProviderIntegrationInstanceData extends Data
{
    public function __construct(
        #[Unique('integration_instances', ignore: new RouteParameterReference('integration_instance', 'id'))]
        public string $name,
        #[Exists('integrations', 'id')]
        public int|Optional $integration_id,
        public array|Optional $connection_settings,
        public ShippingProviderIntegrationSettingsData|Optional $integration_settings,
        public bool|Optional $is_automatic_sync_enabled,
    ) {
    }
}
