<?php

namespace App\Data;

use App\Data\NoteData;
use App\Models\SalesOrder;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\LessThan;
use Spatie\LaravelData\Attributes\Validation\Max;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\ValidationContext;

class UpdateSalesOrderPayloadData extends Data
{
    public function __construct(
        // TODO: Need to enforce uniqueness subject to sales channel
        #[Max(255)]
        public string|Optional $sales_order_number,
        #[Exists('stores', 'id')]
        public int|null|Optional $store_id,
        #[Exists('sales_channels', 'id')]
        public int|Optional $sales_channel_id,
        #[Exists('shipping_methods', 'id')]
        public int|null|Optional $shipping_method_id,
        #[Max(255)]
        public string|null|Optional $requested_shipping_method,
        public string|Optional $order_status,
        public string|Optional $fulfillment_status,
        #[Exists('customers', 'id')]
        public int|null|Optional $customer_id,
        #[Exists('addresses', 'id')]
        public int|null|Optional $shipping_address_id,
        #[Exists('addresses', 'id')]
        public int|null|Optional $billing_address_id,
        public string|null|Optional $payment_status,
        #[Exists('currencies', 'id')]
        public int|Optional $currency_id,
        #[Exists('currencies', 'code')]
        public string|null|Optional $currency_code,
        public string|Optional $order_date,
        public string|null|Optional $payment_date,
        public string|null|Optional $ship_by_date,
        public string|null|Optional $deliver_by_date,
        public string|null|Optional $canceled_at,
        public string|null|Optional $packing_slip_printed_at,
        public string|null|Optional $last_synced_from_sales_channel_at,
        public string|null|Optional $fulfilled_at,
        public string|null|Optional $tracking_number,
        public string|Optional $deleteFulfillmentsReason,
        #[LessThan('1000000')]
        public float|Optional $discount,
        public bool|null|Optional $is_tax_included,
        #[Exists('tax_rates', 'id')]
        public int|null|Optional $tax_rate_id,
        public array|null|Optional $tags,
        #[DataCollectionOf(SalesOrderLineData::class)]
        public DataCollection|Optional $sales_order_lines,
        #[DataCollectionOf(FinancialLineData::class)]
        public DataCollection|Optional $financial_lines,
        #[DataCollectionOf(CustomFieldValueData::class)]
        public DataCollection|Optional $custom_field_values,
        #[DataCollectionOf(NoteData::class)]
        public DataCollection|Optional $notes,
        public CustomerData|null|Optional $customer,
        public AddressData|null|Optional $shipping_address,
        public AddressData|null|Optional $billing_address,
        public bool $shouldDeleteFulfillments = false,
        public bool $shippingAddressChanged = false,
        public bool $on_hold = false,
    )
    {
    }

    public static function rules(ValidationContext $context): array
    {
        return [
            'order_status' => [
                'sometimes',
                'string',
                'in:' . implode(',', SalesOrder::STATUSES),
            ],
        ];
    }
}
