<?php

namespace App\Data;

use App\DTO\ProductWarehousePairDto;
use App\Models\SalesOrder;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class UpdateSalesOrderData extends Data
{
    public function __construct(
        public SalesOrder $salesOrder,
        public UpdateSalesOrderPayloadData $payload,
        #[DataCollectionOf(ProductWarehousePairDto::class)]
        public DataCollection|Optional $productWarehousePairsNeedingCoverageUpdate,
    )
    {
        $this->salesOrder = $this->salesOrder->load('salesOrderFulfillments');
    }
}
