<?php

namespace App\Data;

use App\Models\InventoryAdjustment;
use App\Rules\StandardProductRule;
use App\SDKs\ShipStation\Model\XML\Option;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\BooleanType;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Required;
use Spatie\LaravelData\Attributes\Validation\RequiredWithout;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\ValidationContext;


class UpdateSalesCreditData extends Data
{
    public function __construct(

        #[Rule('max:255')]
        public string|Optional $sales_credit_number,

        #[Exists('warehouses','id')]
        public int|Optional $to_warehouse_id,
        public string|Optional $sales_credit_note,

        #[Rule('date')]
        public string|Optional $credit_date,

        #[Exists('stores','id')]
        public int|Optional $store_id,

        #[RequiredWithout('sales_order_id'),Rule('sometimes')]
        public int|Optional $customer_id,

        #[Exists('currencies','id')]
        public int|Optional $currency_id,

        #[Exists('currencies','code')]
        public string|Optional $currency_code,
        public array|Optional $tax_lines,

        #[Exists('tax_rates','id')]
        public int|Optional $tax_rate_id,

        #[DataCollectionOf(UpdateSalesCreditLineData::class)]
        public DataCollection|null $sales_credit_lines,

        public bool $is_tax_included = false,
        public bool $is_product = false,
    ) {
    }
}