<?php

namespace App\Data;

use App\Abstractions\StockTakeItemDataInterface;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Min;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class StockTakeItemData extends Data implements StockTakeItemDataInterface
{
    public ?int $stock_take_id = null; // to be used for bulk operations

    public function __construct(
        #[Exists('products', 'id')]
        public int $product_id,
        #[Min(1)]
        public float|Optional $qty_counted, // Can set up stock take before doing count
        public float|Optional $qty_change, // Can be used in certain situations where the stock take acts like a bug inventory adjustment
        #[Min(0.01)]
        public float|null $unit_cost, // Can set up stock take before doing count
        public bool $to_delete = false
    )
    {
    }
}
