<?php

namespace App\Data;

use App\Models\IntegrationInstance;
use App\Models\Warehouse;
use Carbon\Carbon;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;

class ShippingProviderIntegrationInstanceData extends Data
{
    public function __construct(
        public int $id,
        public string $name,
        #[Exists('integrations', 'id')]
        public int $integration_id,
        public array $connection_settings,
        public ShippingProviderIntegrationSettingsData $integration_settings,
        public bool $is_automatic_sync_enabled,
        public Carbon $created_at,
        public Carbon $updated_at,
    ) {}

    public static function fromModel(IntegrationInstance $integrationInstance): self
    {
        return new self(
            id: $integrationInstance->id,
            name: $integrationInstance->name,
            integration_id: $integrationInstance->integration_id,
            connection_settings: $integrationInstance->connection_settings,
            integration_settings: ShippingProviderIntegrationSettingsData::from(
                array_merge(
                    $integrationInstance->integration_settings,
                    ['linked_warehouse' => Warehouse::query()->findOrFail($integrationInstance->integration_settings['linked_warehouse_id'])]
                )
            ),
            is_automatic_sync_enabled: $integrationInstance->is_automatic_sync_enabled,
            created_at: $integrationInstance->created_at,
            updated_at: $integrationInstance->updated_at,
        );
    }
}
