<?php

namespace App\Data;

use App\Models\Product;
use App\Models\SalesOrderLine;
use App\Services\SalesOrder\WarehouseRoutingMethod;
use Spatie\LaravelData\Attributes\Validation\RequiredWith;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class SalesOrderLineData extends Data
{
    public function __construct(
        #[RequiredWith('to_delete')]
        public int|null|Optional $id,
        public SalesOrderLine|Optional $salesOrderLine,
        public int|null|Optional $sales_order_id,
        public string|Optional $sales_order_number,
        public string|null|Optional $sales_channel_line_id,
        public int|null|Optional $product_id,
        public Product|null|Optional $product,
        public int|Optional $quantity_to_cancel,
        public string|null|Optional $description,
        public int|null|Optional $warehouse_id,
        public WarehouseRoutingMethod|null|Optional $warehouse_routing_method,
        public int|null|Optional $nominal_code_id,
        public int|Optional|null $tax_rate_id,
        public bool|Optional $to_delete,
        public bool|Optional $is_fulfilled_on_cancelled_line,
        public SalesOrderLineTaxLinesData|Optional $tax_data,
        public float|Optional $fulfilled_quantity,
        public int|null|Optional $product_listing_id,
        public bool|Optional $is_product,
        public int|null|Optional $split_from_line_id,
        public int|null|Optional $bundle_id,
        public int|null|Optional $bundle_quantity_cache,
        public int|null|Optional $bundle_component_quantity_cache,
        public float|Optional $amount,
        public float|Optional $quantity,
        public float|null|Optional $externally_fulfilled_quantity,
        public float|Optional $canceled_quantity,
        public int|Optional $no_audit_trail,
        public int|Optional $has_backorder,
        public float|Optional $discount_allocation,
        public float|Optional $tax_allocation,
        public float|Optional $tax_rate,
        public int|Optional $is_taxable,
    ) {
        if (!is_null($this->product_id) && !$this->product_id instanceof Optional && !$is_product) {
            $this->is_product = true;
        }
    }
}
