<?php

namespace App\Data;

use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\RequiredWithout;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;


class SalesCreditLineData extends Data
{
    public function __construct(

        #[Rule(['numeric','min:1'])]
        public int $quantity,

        #[Exists('sales_order_lines','id'),RequiredWithout('description')]
        public int|Optional $sales_order_line_id,

        #[RequiredWithout('sales_order_line_id')]
        public string|Optional $description,

        #[Rule(['numeric','lt:100000'])]
        public float|Optional $tax_allocation,

        #[Rule('numeric')]
        public float|Optional $amount,

        #[Rule('numeric'), Exists('tax_rates','id')]
        public int|Optional $sales_credit_tax_rate_id,

        #[Exists('nominal_codes','id')]
        public int|null $nominal_code_id,

        #[Rule('nullable'), Exists('tax_rates','id')]
        public int|null $tax_rate_id,

        public bool $is_product = false

    ) {
    }
}