<?php

namespace App\Data;

use App\Enums\FinancialLineProrationStrategyEnum;
use App\Models\TaxRate;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class FinancialLineData extends Data
{
    public function __construct(
        public int|null|Optional $id,
        public int|Optional $sales_order_id,
        public string|Optional|null $sales_order_number,
        public int|Optional $financial_line_type_id,
        public string|Optional $description,
        public int|Optional $quantity,
        public float|Optional $amount,
        public float|Optional $tax_allocation,
        public int|Optional|null $tax_rate_id,
        public float|Optional $tax_rate,
        public int|Optional $allocate_to_products,
        public FinancialLineProrationStrategyEnum|Optional $proration_strategy,
        public ?int $allocate_to_id,
        public ?string $allocate_to_type,
        public ?string $sales_channel_line_id,
        public ?int $nominal_code_id,
        public ?string $external_source_type,
        public ?int $external_source_id,
    ) {
    }

    public static function rules(): array
    {
        $request = request();
        $requiredRule = $request->isMethod('POST') ? 'required' : 'sometimes';

        return [
            'financial_line_type_id' => "$requiredRule|exists:financial_line_types,id",
            'nominal_code_id' => 'sometimes|nullable|exists:nominal_codes,id',
            'description' => 'sometimes|string',
            'quantity' => 'sometimes|integer|min:1',
            'amount' => "$requiredRule|numeric|min:0",
            'tax_allocation' => 'sometimes|numeric|min:0',
            'tax_rate_id' => 'sometimes|in:'.implode(',', array_column(TaxRate::all()->toArray(), 'id')),
            'tax_rate' => 'sometimes|numeric|min:0',
            'allocate_to_products' => 'sometimes|boolean',
            'proration_strategy' => 'sometimes|in:'.implode(',', array_column(FinancialLineProrationStrategyEnum::cases(), 'value')),
            'allocate_to_id' => 'sometimes|nullable|integer',
            'allocate_to_type' => 'sometimes|nullable|string',
        ];
    }
}
